/*
   This program reads lines from standard input (stdin)
   and filters them to standard output (stdout) but this
   program first "redirects" its standard output to be
   a child process. This creates a simple, two stage
   pipeline made up of the parent and child processes.

   If standard input is the console keyboard,
   use ^z (Control-z) to denote the end of file
   (and you must use ^z at the beginning of a line!).

   Important: Notice how this program is similar to
   the following command line pipe.

   C:\> java RemoveVowels | java Double

   In the case of the above command line, the shell
   program (cmd.exe) sets up the I/O redirection
   (the pipe) before running the two programs
   RemoveVowels.class and Double.class. In the case
   of this program, this program itself does its own
   I/O redirection (setting up the pipe) between itself
   (which acts like RemoveVowels.java) and its child
   process before running the child process.
*/
import java.util.Scanner;
import java.io.*;

public class Java6_ParentChildPipeline_ver3
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // Create a command line for running the filter.
      String cmd = "java Double";
      // Execute the filter.
      Process process = Runtime.getRuntime().exec(cmd);

      final PrintStream myStdout = System.out;  // save the parent's output stream

      // Redirect System.out to be the standard input of the filter program
      // (this is the "pipeline" between the parent and the child).
      System.setOut( new PrintStream( process.getOutputStream() ) );

      // Create a Scanner object to make it easier to use System.in
      Scanner scanner = new Scanner( System.in );

      // Create a new stream to read data from the output of the filter.
      final Scanner stdoutOfChild = new Scanner( process.getInputStream() );


      // Create a "pump" between the child's output stream
      // and the parent's original (saved) stdout.
      new Thread(new Runnable(){public void run()
      {while(stdoutOfChild.hasNextLine())
       {String oneLine = stdoutOfChild.nextLine(); // read from output of child
        myStdout.println( oneLine );               // write to the original stdout
       }}}).start();


      // Send each line of data from stdin to the next stage (the child).
      while ( scanner.hasNextLine() )
      {
         String oneLine = scanner.nextLine(); // read from stdin
         // Filter the line of input before
         // sending it to the next stage.
         for (int i = 0; i < oneLine.length(); i++)
         {
            if ( -1 == "aeiouAEIOU".indexOf( oneLine.charAt(i) ) )
               System.out.print( oneLine.charAt(i) ); // write to stdout
         }
         System.out.println();            // write to stdout (which is the next stage)
         //System.out.flush();
      }
      System.out.close();  // THIS IS IMPORTANT, without it the child hangs

      // Wait for the child to finish its work.
      process.waitFor();  // this throws InterruptedException
   }
}

/*
   Question:
   How does line 72,
      System.out.flush();
   effect this program and why?
*/

/*
   Question:
   Can you, as in Java6_ParentChildPipeline_ver2,java,
   get rid of the two lines 74
      System.out.close();
   and  77
      process.waitFor();
   How does removing those two line affect this program
   and why?
*/